Attribute VB_Name = "Module1"
Public Function FontNotFoundProc(ByVal Data As Long, ByVal PDFFont As Long, ByVal FontName As Long, ByVal Style As TFStyle, ByVal StdFontIndex As Long, ByVal IsSymbolFont As Long) As Long
   If Form1.pdf.WeightFromStyle(Style) < 500 Then
      Style = Style And &HF
      Style = Style Or TFStyle.fsRegular
   End If
   FontNotFoundProc = Form1.pdf.ReplaceFont(PDFFont, "Arial", Style, True)
End Function

Public Function ReplaceICCProfileProc(ByVal Data As Long, ByVal ProfileType As TICCProfileType, ByVal ColorSpace As Long) As Long
   ' The most important ICC profiles are available free of charge from Adobe. Just seach for "Adobe icc profiles".
   Select Case ProfileType
      Case TICCProfileType.ictRGB
         ReplaceICCProfileProc = Form1.pdf.ReplaceICCProfile(ColorSpace, "../../../test_files/sRGB.icc")
      Case TICCProfileType.ictCMYK
         ReplaceICCProfileProc = Form1.pdf.ReplaceICCProfile(ColorSpace, "../../../test_files/ISOcoated_v2_bas.ICC") ' This is just an example CMYK profile that can be delivered with DynaPDF
      Case Else
         ReplaceICCProfileProc = -1 ' A gray profile is never requested since DynaPDF creates such a profile on demand if necessary.
   End Select
End Function

